<?php
require __DIR__ . '/../../includes/auth.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  $res = auth_login($username, $password);
  if ($res['success']) {
    header('Location: /sbn/waste_seg_form/public/admin/dashboard.php');
    exit;
  } else {
    $error = $res['message'] ?? 'Login failed';
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Login • Waste Segregation</title>
  <link rel="stylesheet" href="../assets/admin.css">
</head>
<body class="auth">
  <div class="auth-card">
    <h1>Admin Login</h1>
    <?php if ($error): ?>
      <div class="alert"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="post" autocomplete="off" novalidate>
      <label>
        <span>Username</span>
        <input name="username" type="text" required>
      </label>
      <label>
        <span>Password</span>
        <input name="password" type="password" required>
      </label>
      <button type="submit">Sign in</button>
    </form>
    <p class="help">Roles supported: <strong>president</strong> and <strong>dm</strong></p>
  </div>
</body>
</html>
