<?php
require __DIR__ . '/../../includes/auth.php';
require_login(['president','dm']);
$me = auth_user();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard • Waste Segregation</title>
  <link rel="stylesheet" href="../assets/admin.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="dash">
 <header class="topbar">
  <div class="brand">Waste Segregation Dashboard</div>
  <div class="user">Logged in as <?= htmlspecialchars($me['username']) ?> (<?= htmlspecialchars(strtoupper($me['role'])) ?>) • <a href="/sbn/waste_seg_form/public/admin/logout.php">Logout</a></div>
</header>


  <main class="container">
    <section class="panel">
      <div class="panel-head">
        <h2>Status Overview</h2>
        <div class="controls">
          <label for="ward-select">Ward:</label>
          <select id="ward-select">
            <option value="all" selected>All Wards</option>
            <option value="w1">W1</option>
            <option value="w2">W2</option>
            <option value="w3">W3</option>
            <option value="w4">W4</option>
            <option value="w5">W5</option>
          </select>
        </div>
      </div>
      <div class="kpis">
        <div class="kpi"><div class="k-title">Total Households</div><div id="k-total" class="k-value">-</div></div>
        <div class="kpi"><div class="k-title good">Segregating</div><div id="k-yes" class="k-value">-</div></div>
        <div class="kpi"><div class="k-title bad">Not Segregating</div><div id="k-no" class="k-value">-</div></div>
      </div>
      <div class="chart-wrap">
        <canvas id="pie"></canvas>
      </div>
    </section>

    <section class="panel">
      <div class="panel-head">
        <h2>Growth by Survey Round</h2>
      </div>
      <div class="chart-wrap">
        <canvas id="bar"></canvas>
      </div>
    </section>
  </main>

  <footer class="footer">
    <div>Tips: Use the ward filter to drill down. Charts update instantly.</div>
  </footer>

  <script src="../assets/admin.js"></script>
</body>
</html>
