
(() => {
  const wardSelect = document.getElementById('ward-select');
  const kTotal = document.getElementById('k-total');
  const kYes = document.getElementById('k-yes');
  const kNo = document.getElementById('k-no');
  const pieCtx = document.getElementById('pie').getContext('2d');
  const barCtx = document.getElementById('bar').getContext('2d');

  let pieChart, barChart;

  async function loadData() {
    const ward = wardSelect.value;
    const r = await fetch(`api_dashboard.php?ward=${encodeURIComponent(ward)}`);
    const data = await r.json();

    // KPIs
    kTotal.textContent = data.totals.total.toLocaleString();
    kYes.textContent = data.totals.yes.toLocaleString();
    kNo.textContent = data.totals.no.toLocaleString();

    // Pie
    const pieData = {
      labels: ['Segregating','Not segregating'],
      datasets: [{
        data: [data.totals.yes, data.totals.no]
      }]
    };
    if (pieChart) pieChart.destroy();
    pieChart = new Chart(pieCtx, {
      type: 'pie',
      data: pieData,
      options: {
        plugins: { legend: { position: 'bottom' } },
        maintainAspectRatio: false
      }
    });

    // Bar
    const barData = {
      labels: data.growth.labels,
      datasets: [{
        label: 'Households segregating',
        data: data.growth.yes
      }]
    };
    if (barChart) barChart.destroy();
    barChart = new Chart(barCtx, {
      type: 'bar',
      data: barData,
      options: {
        scales: { y: { beginAtZero: true, ticks: { precision:0 } } },
        plugins: { legend: { display: false } },
        maintainAspectRatio: false
      }
    });
  }

  wardSelect.addEventListener('change', loadData);
  window.addEventListener('load', loadData);
})();
