<?php
require __DIR__ . '/../../includes/auth.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  $res = auth_login($username, $password);
  if ($res['success']) {
    header('Location: /sbm/public/admin/dashboard.php');
    exit;
  } else {
    $error = $res['message'] ?? 'Login failed';
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Favicon -->
  <link rel="icon" type="image/png" href="favicon-ws.png">
  <title>Admin Login • Waste Segregation</title>
  <link rel="stylesheet" href="../assets/admin.css">
  <style>
    .password-wrapper {
      position: relative;
    }

    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 10px 42px 10px 10px;
      border-radius: 10px;
      border: 1px solid #2b3440;
      background-color: #0b1220;
      color: #fff;
      font-size: 0.95rem;
      box-sizing: border-box;
    }

    input:focus {
      outline: none;
      border-color: #58a6ff;
    }

    /* clean svg icon */
    .toggle-password {
      position: absolute;
      right: 10px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #94a3b8;
      transition: color 0.2s;
      display: flex;
      align-items: center;
      justify-content: center;
    }

   

    .toggle-password svg {
      width: 20px;
      height: 20px;
      stroke-width: 1.6;
      stroke: currentColor;
      fill: none;
      pointer-events: none;
    }
  </style>
</head>
<body class="auth">
  <div class="auth-card">
    <h1>Admin Login</h1>

    <?php if ($error): ?>
      <div class="alert"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off" novalidate>
      <label>
        <span>Username</span>
        <input name="username" type="text" required>
      </label>

      <label>
        <span>Password</span>
        <div class="password-wrapper">
          <input id="password" name="password" type="password" required>
          <div id="togglePassword" class="toggle-password">
            <!-- open eye -->
            <svg id="eyeOpen" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
              <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7S1 12 1 12z" stroke-linecap="round" stroke-linejoin="round"/>
              <circle cx="12" cy="12" r="3" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            <!-- eye with slash -->
            <svg id="eyeClosed" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" style="display:none;">
              <svg id="eyeOpen" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
              <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7S1 12 1 12z" stroke-linecap="round" stroke-linejoin="round"/>
              <circle cx="12" cy="12" r="3" stroke-linecap="round" stroke-linejoin="round"/>
              <line x1="2" y1="2" x2="22" y2="22" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </div>
        </div>
      </label>

      <button type="submit">Sign in</button>
    </form>

    <!--<p class="help">Roles supported: <strong>president</strong> and <strong>dm</strong></p>-->
  </div>

  <script>
    const toggle = document.getElementById('togglePassword');
    const password = document.getElementById('password');
    const eyeOpen = document.getElementById('eyeOpen');
    const eyeClosed = document.getElementById('eyeClosed');

    toggle.addEventListener('click', () => {
      const isPassword = password.type === 'password';
      password.type = isPassword ? 'text' : 'password';
      eyeOpen.style.display = isPassword ? 'none' : 'block';
      eyeClosed.style.display = isPassword ? 'block' : 'none';
    });
  </script>
</body>
</html>
