<?php // public/home.php
$bannerSrc = 'WhatsApp Image 2025-10-03 at 11.02.46.jpeg'; // update if you renamed it
$siteTitle = 'Waste Segregation';
$links = [
    ['label' => 'Executive Registration', 'href' => 'volunteer_register.php', 'desc' => 'Register a New Executive'],
    ['label' => 'Executive Login', 'href' => 'executive_login.php', 'desc' => 'Login Existing Executive'],
    ['label' => 'Resident Registration', 'href' => 'index.php', 'desc' => 'Register a house / resident'],
    ['label' => 'Revisit Form', 'href' => 'officer.php', 'desc' => 'Executive revisit entries'],
    ['label' => 'Create Admin User', 'href' => 'tools/admin_create.php', 'desc' => 'Sign in as Super Admin'],
    
    ['label' => 'Admin Panel', 'href' => 'admin/login.php', 'desc' => 'Sign in to manage data'],
  
];
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Favicon -->
  <link rel="icon" type="image/png" href="favicon-ws.png">

  <!-- Page title -->
  <title>Waste Segregation — Home</title>

  <style>
    :root{
      --accent: #2fa84f;
      --accent-dark: #1f7a39;
      --muted: #6b6b6b;
      --bg: #f8faf8;
      --card-bg: #ffffff;
      --radius: 12px;
      --max-width: 1100px;
      --gap: 16px;
      font-family: Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
    }
    *{box-sizing:border-box}
    body{
      margin:0;
      background: linear-gradient(180deg,#fbfff8 0%,#f5fff5 100%);
      color:#222;
      padding:20px;
      display:flex;
      justify-content:center;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
      line-height:1.4;
      font-size:16px;
    }

    .container{
      width:100%;
      max-width:var(--max-width);
      background:transparent;
    }

    /* ========== Banner ========== */
    .banner{
      background:var(--card-bg);
      border-radius: var(--radius);
      overflow:visible; /* allow full banner to be shown */
      box-shadow: 0 6px 18px rgba(32,50,25,0.06);
      margin-bottom: var(--gap);
      position:relative;
      padding:14px; /* provide breathing room when image is contained */
    }
    /* default: keep aspect and show whole image instead of cropping */
    .banner img{
      display:block;
      width:100%;
      height:auto;           /* ensures full image visible */
      max-height:320px;      /* limits huge images */
      object-fit: contain;   /* show whole image (no crop) */
      border-radius:10px;
      box-shadow: 0 4px 12px rgba(20,40,12,0.04);
    }

    /* On small screens keep a slightly smaller max height */
    @media (max-width:520px){
      .banner{ padding:10px; }
      .banner img{ max-height:200px; }
    }

    /* For very wide screens, let banner be taller so it looks full-width */
    @media (min-width:1024px){
      .banner img{ max-height:420px; object-fit: contain; }
    }

    /* ========== Topbar (brand + actions) ========== */
    .topbar{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:12px;
      margin-top:8px;
      flex-wrap:nowrap; /* prevent wrap by default */
    }

    .brand{
      display:flex;
      gap:12px;
      align-items:center;
      min-width:0; /* allow contents to shrink */
      flex:1 1 auto; /* allow brand to take remaining space */
    }
    .logo{
      width:48px;
      height:48px;
      border-radius:12px;
      background:linear-gradient(180deg,var(--accent),var(--accent-dark));
      display:grid;
      place-items:center;
      color:#fff;
      font-weight:700;
      font-size:18px;
      flex:0 0 auto;
      box-shadow: 0 3px 10px rgba(47,168,79,0.18);
    }
    .brand .title-wrap{ overflow:hidden; min-width:0; }
    .brand h1{ margin:0; font-size:18px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden; }
    .brand p{ margin:0; color:var(--muted); font-size:13px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden; }

    .actions{
      display:flex;
      gap:10px;
      align-items:center;
      flex:0 0 auto;  /* prevent actions area from shrinking smaller than its content */
      white-space:nowrap; /* force buttons stay on same row */
    }

    .btn{
      background:transparent;
      border:1px solid rgba(0,0,0,0.06);
      padding:8px 12px;
      border-radius:10px;
      cursor:pointer;
      font-weight:600;
      display:inline-flex;
      gap:8px;
      align-items:center;
      transition:all .18s ease;
      text-decoration:none;
      color:var(--accent-dark);
    }
    .btn.primary{
      background:var(--accent);
      color:#fff;
      border:none;
      box-shadow: 0 6px 12px rgba(47,168,79,0.12);
      padding:10px 16px;
      border-radius:14px;
    }

    /* On narrow screens, keep brand and actions on one line:
       - allow brand text to shrink and ellipsize
       - keep action buttons compact
    */
    @media (max-width:520px){
      .logo{ width:44px; height:44px; }
      .brand h1{ font-size:16px; }
      .brand p{ font-size:12px; }
      .actions .btn.primary{ padding:10px 12px; font-size:14px; } /* smaller primary so it fits */
    }

    /* ========== Link grid ========== */
    .grid{
      display:grid;
      grid-template-columns: repeat(3, 1fr);
      gap:var(--gap);
      margin-top:14px;
    }
    .card{
      background:var(--card-bg);
      border-radius:14px;
      padding:16px;
      min-height:110px;
      box-shadow: 0 6px 18px rgba(35,50,30,0.04);
      display:flex;
      flex-direction:column;
      justify-content:space-between;
      transition:transform .16s ease, box-shadow .16s ease;
      text-decoration:none;
      color:inherit;
    }
    .card h3{ margin:0;font-size:16px; }
    .card p{ margin:6px 0 0 0; color:var(--muted); font-size:13px; }

    .card .meta{
      display:flex;
      justify-content:space-between;
      align-items:center;
      gap:8px;
      margin-top:12px;
    }
    .chip{
      font-size:12px;
      padding:6px 8px;
      border-radius:999px;
      background:rgba(47,168,79,0.08);
      color:var(--accent-dark);
      font-weight:600;
    }

    /* responsive grid */
    @media (max-width:900px){
      .grid{ grid-template-columns: repeat(2,1fr); }
    }
    @media (max-width:520px){
      .grid{ grid-template-columns: 1fr; gap:12px;}
      .card{ padding:14px; min-height:88px; border-radius:12px; }
    }

    /* small helper for icons */
    .icon{ width:18px; height:18px; display:inline-block; }

    .footer-note{ margin-top:14px; color:var(--muted); font-size:13px; text-align:center; }
    /* Hide the New Registration button on very small screens */
@media (max-width:425px){
  .actions .btn.primary {
    display: none !important;
  }
}


  </style>
</head>
<body>
  <div class="container">

    <!-- banner -->
    <div class="banner" role="banner" aria-label="Top banner">
      <?php if (file_exists($bannerSrc)): ?>
        <img src="<?php echo htmlspecialchars($bannerSrc); ?>" alt="Waste segregation banner">
      <?php else: ?>
        <div style="padding:28px 16px; display:flex; align-items:center; gap:12px;">
          <div style="width:84px;height:84px;border-radius:12px;background:linear-gradient(180deg,var(--accent),var(--accent-dark));display:grid;place-items:center;color:white;font-weight:700;font-size:22px;">WS</div>
          <div>
            <h2 style="margin:0;"><?php echo htmlspecialchars($siteTitle); ?></h2>
            <p style="margin:0;color:var(--muted)">Banner image not found. Put the banner next to this file or update $bannerSrc.</p>
          </div>
        </div>
      <?php endif; ?>
    </div>

    <!-- topbar -->
    <div class="topbar" role="navigation" aria-label="Home navigation">
      <div class="brand">
        <div class="logo">WS</div>
        <div class="title-wrap">
          <h1><?php echo htmlspecialchars($siteTitle); ?></h1>
          <p>Municipal waste segregation portal</p>
        </div>
      </div>

      <div class="actions">
       <!-- <a class="btn primary" href="index.php" title="New registration">➕ New Registration</a>-->
      </div>
    </div>

    <!-- links -->
    <main>
      <div class="grid" role="list">
        <?php foreach($links as $l):
          $label = $l['label'];
          $href  = $l['href'];
          $desc  = isset($l['desc']) ? $l['desc'] : '';
        ?>
        <a class="card" role="listitem" href="<?php echo htmlspecialchars($href); ?>">
          <div>
            <h3><?php echo htmlspecialchars($label); ?></h3>
            <p><?php echo htmlspecialchars($desc); ?></p>
          </div>

          <div class="meta">
            <div class="chip">Open</div>
            <svg class="icon" viewBox="0 0 24 24" fill="none" aria-hidden="true">
              <path d="M5 12h14M13 5l6 7-6 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </div>
        </a>
        <?php endforeach; ?>
      </div>

    </main>
  </div>

  <script>
    // small click feedback
    document.addEventListener('click', function(e){
      var card = e.target.closest('.card');
      if(!card) return;
      card.animate([{ transform: 'scale(0.997)' }, { transform: 'scale(1)' }], { duration: 160 });
    });

    // keyboard activation
    document.querySelectorAll('.card').forEach(function(c){
      c.setAttribute('tabindex', '0');
      c.addEventListener('keydown', function(ev){
        if(ev.key === 'Enter' || ev.key === ' ') { ev.preventDefault(); c.click(); }
      });
    });
  </script>
</body>
</html>
