<?php
// public/officer.php
require __DIR__ . '/../includes/db.php'; // adjust include path if required

function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$phone_q = isset($_GET['phone']) ? preg_replace('/\D/','', $_GET['phone']) : '';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Officer — Revisit</title>
  <link rel="stylesheet" href="assets/style.css">
  <style>
    /* small inline safety */
    #resident-data { display: none; margin-top:12px; }
    #previous-trainings { margin-top:12px; }
    #photo-preview-off { margin-top:12px; }
    #canvas { display:none; } /* shared canvas hidden */
  </style>
</head>
<body>
  <div class="container">
    <header class="page-header">
      <div class="title">Officer — Revisit / Training</div>
      <div class="lead">Lookup residents and record follow-up trainings</div>
    </header>

    <div class="form-card registration-card">
      <form id="lookup-form" class="reg-grid" method="get" action="officer.php">
        <div class="reg-meta field">
          <label for="lookup_phone">Lookup by phone</label>
          <input id="lookup_phone" name="phone" type="tel" placeholder="10-digit mobile" value="<?= h($phone_q) ?>">
        </div>
        <div class="field actions-center" style="align-self:end">
          <button id="lookup" type="button" class="btn primary">Lookup</button>
          <a class="btn ghost" href="index.php">New registration</a>
        </div>
      </form>
    </div>

    <!-- resident details -->
    <div id="resident-data" class="resident-card" aria-hidden="true">
      <div class="section-title-row">
        <h3 class="section-title">Resident details</h3>
      </div>

      <div class="resident-grid">
        <div class="resident-row">
          <div class="resident-label">ID</div>
          <div class="resident-value"><div class="value-field" id="r_id">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">Name</div>
          <div class="resident-value"><div class="value-field" id="r_name">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">Phone</div>
          <div class="resident-value"><div class="value-field" id="r_phone">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">ULB</div>
          <div class="resident-value"><div class="value-field" id="r_ulb">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">Ward</div>
          <div class="resident-value"><div class="value-field" id="r_ward">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">House / address</div>
          <div class="resident-value"><div class="value-field" id="r_house_no">—</div></div>
        </div>

        <div class="resident-row">
          <div class="resident-label">Photo</div>
          <div class="resident-value">
            <div id="reg-photo" class="reg-photo"></div>
          </div>
        </div>
      </div>

      <hr style="margin:14px 0;border:none;border-top:1px solid rgba(10,20,40,0.04)">

      <div>
        <h4 class="section-subtitle">Previous trainings</h4>
        <div id="previous-trainings"></div>
      </div>
    </div>

    <!-- next training form -->
    <div id="next-training-section" class="registration-card" style="display:none;margin-top:12px">
      <form id="officer-form" method="post" action="submit.php" class="form-card">
        <input type="hidden" id="resident_id" name="resident_id" value="">
        <div class="col-grid">
          <div class="field">
            <label for="r_date">Date <span class="req-inline">*</span></label>
            <input id="r_date" name="date" type="date" />
          </div>
          <div class="field">
            <label for="r_time">Time <span class="req-inline">*</span></label>
            <input id="r_time" name="time" type="time" />
          </div>

          <div class="field full group-bg">
            <label>Waste segregation <span class="req-inline">*</span></label>
            <div class="radio-row">
              <label class="radio-label"><input type="radio" name="waste_segregation" value="segregated" /> Segregated</label>
              <label class="radio-label"><input type="radio" name="waste_segregation" value="not" /> Not segregated</label>
            </div>
          </div>

          <!-- officer camera -->
          <div class="field full camera-wrap">
            <label>Capture visit photo <span class="req-inline">*</span></label>
            <div id="camera-area-off">
              <video id="video" playsinline></video>
              <div class="camera-controls-off">
                <button type="button" id="open-camera-off" class="btn">Open camera</button>
                <button type="button" id="take-photo-off" class="btn ghost" style="display:none">Take photo</button>
                <button type="button" id="retake-photo-off" class="btn ghost" style="display:none">Retake</button>
              </div>
              <div id="photo-preview-off" class="photo-preview"></div>
              <canvas id="canvas"></canvas>
              <input type="hidden" id="photo_data_off" name="photo_data_off" value="">
            </div>
          </div>

        </div> <!-- end col-grid -->

        <div class="actions">
          <button id="save-training" type="button" class="btn primary large">Save Training</button>

      </div> <!-- /resident-data -->
    </form>
  </main>

  <?php $cfg = require __DIR__ . '/../includes/config.php'; ?>
<script>
window.APP_CFG = {
  MAPBOX_TOKEN: "<?= htmlspecialchars($cfg['mapbox_token'] ?? '') ?>",
  GOOGLE_KEY: "<?= htmlspecialchars($cfg['google_key'] ?? '') ?>"
};
</script>
  <script src="assets/app.js?v=6"></script>

  <script>
    // small now label
    const nowLabel = document.getElementById('now-label');
    // no-op here; app.js handles lookup wiring
  
  
  <!-- Lightbox: show tapped/clicked image larger (works for dynamically created images) -->

</script>
<script>
/* Robust lightbox (single instance) — works with dynamically inserted images.
   Place this after your app.js include in both pages.
*/
(function(){
  // Create single lightbox elements and attach handlers
  if (document.querySelector('.lightbox-backdrop')) {
    // already present (safety)
    return;
  }

  const backdrop = document.createElement('div');
  backdrop.className = 'lightbox-backdrop';
  backdrop.setAttribute('aria-hidden', 'true');

  const inner = document.createElement('div');
  inner.className = 'lightbox-inner';

  const loader = document.createElement('div');
  loader.className = 'lightbox-loader';
  loader.style.display = 'none';

  const img = document.createElement('img');
  img.className = 'lightbox-img';
  img.alt = 'Photo preview';
  img.style.display = 'none';

  const closeBtn = document.createElement('button');
  closeBtn.className = 'lightbox-close';
  closeBtn.innerHTML = '✕';
  closeBtn.setAttribute('aria-label', 'Close preview');

  // assemble
  inner.appendChild(loader);
  inner.appendChild(img);
  inner.appendChild(closeBtn);
  backdrop.appendChild(inner);
  document.body.appendChild(backdrop);

  // helper functions
  let currentSrc = '';
  function show(src) {
    if (!src) return;
    currentSrc = src;
    backdrop.style.display = 'flex';
    backdrop.setAttribute('aria-hidden', 'false');
    document.body.style.overflow = 'hidden';

    // show loader while image loads
    loader.style.display = '';
    img.style.display = 'none';
    img.src = ''; // reset

    // pre-load image
    const tmp = new Image();
    tmp.onload = function() {
      // success — set src and show
      img.src = src;
      loader.style.display = 'none';
      img.style.display = '';
      // ensure focus for accessibility
      closeBtn.focus({preventScroll:true});
    };
    tmp.onerror = function() {
      loader.style.display = 'none';
      img.style.display = 'none';
      // fallback: show a small error message
      const err = document.createElement('div');
      err.style.color = '#fff';
      err.style.padding = '8px';
      err.textContent = 'Could not load image.';
      // remove any previous error nodes
      const previous = inner.querySelector('.lb-error');
      if (previous) previous.remove();
      err.className = 'lb-error';
      inner.appendChild(err);
      setTimeout(()=> { if (err) err.remove(); }, 2500);
    };
    tmp.src = src;
  }

  function hide() {
    backdrop.style.display = 'none';
    backdrop.setAttribute('aria-hidden', 'true');
    document.body.style.overflow = '';
    img.src = '';
    currentSrc = '';
    // remove any transient error nodes
    const previous = inner.querySelector('.lb-error');
    if (previous) previous.remove();
  }

  // event wiring
  closeBtn.addEventListener('click', hide);
  // click outside to close
  backdrop.addEventListener('click', (ev) => {
    if (ev.target === backdrop) hide();
  });
  // escape key
  document.addEventListener('keydown', (ev) => { if (ev.key === 'Escape') hide(); });

  // delegate clicks/taps on images (works for dynamic inserts)
  document.addEventListener('click', function(e) {
    const t = e.target;
    if (!t) return;
    // Only open when clicking the actual image (not its container) OR clicking inside .training-image wrapper
    let targetImg = null;
    if (t.tagName === 'IMG' && (t.closest('.training-image') || t.closest('#previous-trainings') || t.closest('#training-list') || t.closest('#reg-photo') || t.closest('#photo-preview'))) {
      targetImg = t;
    } else {
      // if clicked wrapper with an image inside
      const wrapper = t.closest('.training-image, #previous-trainings, #training-list, #reg-photo, #photo-preview');
      if (wrapper) {
        targetImg = wrapper.querySelector('img');
      }
    }
    if (targetImg && targetImg.src) {
      // prevent default link behavior if inside an <a>
      if (e.defaultPrevented) return;
      e.preventDefault && e.preventDefault();
      show(targetImg.src);
    }
  }, { passive: false });

})();
</script>

</body>
</html>
